#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int N;
    cin >> N;
    
    vector<long long> A(N), B(N);
    for(int i = 0; i < N; i++) cin >> A[i];
    for(int i = 0; i < N; i++) cin >> B[i];
    
    vector<int> prefix_b(N); // Prefix AND array
    prefix_b[0] = B[0];
    for(int i = 1; i < N; i++) {
        prefix_b[i] = prefix_b[i-1] & B[i];
    }
    
    long long maxValue = 0;
    
    // Za svaku mogucu pocetnu poziciju
    for(int start = 0; start < N; start++) {
        // Pocetne vrednosti za trenutni AND interval
        long long current_and = B[start];
        long long current_xor = A[start];
        maxValue = max(maxValue, current_xor * current_and);
        
        // Pre-racunamo potencijalne AND vrednosti
        vector<pair<long long, int>> potential_ands;
        potential_ands.push_back({current_and, start});
        
        for(int i = start + 1; i < N; i++) {
            current_and &= B[i];
            if(current_and != potential_ands.back().first) {
                potential_ands.push_back({current_and, i-1});
            }
        }
        potential_ands.push_back({current_and, N-1});
        
        // Za svaki jedinstveni AND interval
        for(int i = 0; i < (int)potential_ands.size() - 1; i++) {
            long long and_value = potential_ands[i].first;
            int end = potential_ands[i+1].second;
            
            // Optimizovano racunanje XOR-a za svaku poziciju
            current_xor = A[start];
            for(int pos = start + 1; pos <= end; pos++) {
                current_xor ^= A[pos];
                maxValue = max(maxValue, current_xor * and_value);
            }
        }
    }
    
    cout << maxValue << "\n";
    
    return 0;
}